/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.widgets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.figuramc.figura.gui.widgets.FiguraWidget;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.MathUtils;
import org.figuramc.figura.utils.ui.UIHelper;

public class ScrollBarWidget
extends AbstractWidget
implements FiguraWidget {
    public static final ResourceLocation SCROLLBAR_TEXTURE = new FiguraIdentifier("textures/gui/scrollbar.png");
    protected final int headHeight = 20;
    protected final int headWidth = 10;
    protected boolean isScrolling = false;
    protected boolean vertical = true;
    protected double scrollPos;
    protected double scrollPrecise;
    protected double scrollRatio = 1.0;
    protected OnPress onPress;

    public ScrollBarWidget(int x, int y, int width, int height, double initialValue) {
        super(x, y, width, height, (Component)Component.empty());
        this.scrollPrecise = initialValue;
        this.scrollPos = initialValue;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!(this.isActive() && this.isHoveredOrFocused() && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        if (button == 0) {
            double scrollPos = Mth.lerp((double)this.scrollPrecise, (double)0.0, (double)((double)(this.vertical ? this.getHeight() - 20 : this.getWidth() - 10) + 2.0));
            if (this.vertical && mouseY < (double)this.getY() + scrollPos || mouseY > (double)this.getY() + scrollPos + 20.0) {
                this.scroll(-((double)this.getY() + scrollPos + 10.0 - mouseY));
            } else if (!this.vertical && mouseX < (double)this.getX() + scrollPos || mouseX > (double)this.getX() + scrollPos + 10.0) {
                this.scroll(-((double)this.getX() + scrollPos + 5.0 - mouseX));
            }
            this.isScrolling = true;
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            if (this.vertical) {
                if (Math.signum(deltaY) == -1.0) {
                    if (mouseY <= (double)(this.getY() + this.getHeight())) {
                        this.scroll(deltaY);
                        return true;
                    }
                } else if (mouseY >= (double)this.getY()) {
                    this.scroll(deltaY);
                    return true;
                }
            } else if (Math.signum(deltaX) == -1.0) {
                if (mouseX <= (double)(this.getX() + this.getWidth())) {
                    this.scroll(deltaX);
                    return true;
                }
            } else if (mouseX >= (double)this.getX()) {
                this.scroll(deltaX);
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        if (!this.isActive()) {
            return false;
        }
        this.scroll(-amount - d * (double)(this.vertical ? this.getHeight() : this.getWidth()) * 0.05 * this.scrollRatio);
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (keyCode > 261 && keyCode < 266) {
            this.scroll((double)((keyCode % 2 == 0 ? 1 : -1) * (this.vertical ? this.getHeight() : this.getWidth())) * 0.05 * this.scrollRatio);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return UIHelper.isMouseOver(this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY);
    }

    protected void scroll(double amount) {
        this.scrollPrecise += amount / ((double)(this.vertical ? this.getHeight() - 20 : this.getWidth() - 10) + 2.0);
        this.setScrollProgress(this.scrollPrecise);
    }

    protected void lerpPos(float delta) {
        float lerpDelta = MathUtils.magicDelta(0.2f, delta);
        this.scrollPos = Mth.lerp((double)lerpDelta, (double)this.scrollPos, (double)this.getScrollProgress());
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (!this.isVisible()) {
            return;
        }
        this.isHovered = this.isMouseOver(mouseX, mouseY);
        UIHelper.enableBlend();
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        gui.blit(SCROLLBAR_TEXTURE, x, y, width, 1, 10.0f, this.isScrolling ? 20.0f : 0.0f, 10, 1, 20, 40);
        gui.blit(SCROLLBAR_TEXTURE, x, y + 1, width, height - 2, 10.0f, this.isScrolling ? 21.0f : 1.0f, 10, 18, 20, 40);
        gui.blit(SCROLLBAR_TEXTURE, x, y + height - 1, width, 1, 10.0f, this.isScrolling ? 39.0f : 19.0f, 10, 1, 20, 40);
        this.lerpPos(delta);
        gui.blit(SCROLLBAR_TEXTURE, x, (int)((long)y + Math.round(Mth.lerp((double)this.scrollPos, (double)0.0, (double)(height - 20)))), 0.0f, this.isHoveredOrFocused() || this.isScrolling ? 20.0f : 0.0f, 10, 20, 20, 40);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public void setX(int x) {
        super.setX(x);
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public double getScrollProgress() {
        return this.scrollPrecise;
    }

    public void setScrollProgress(double amount) {
        this.setScrollProgress(amount, false);
    }

    public void setScrollProgressNoAnim(double amount) {
        this.setScrollProgress(amount, false);
        this.scrollPos = this.scrollPrecise;
    }

    public void setScrollProgress(double amount, boolean force) {
        amount = Double.isNaN(amount) ? 0.0 : amount;
        double d = this.scrollPrecise = force ? amount : Mth.clamp((double)amount, (double)0.0, (double)1.0);
        if (this.onPress != null) {
            this.onPress.onPress(this);
        }
    }

    public void setAction(OnPress onPress) {
        this.onPress = onPress;
    }

    public void setScrollRatio(double entryHeight, double heightDiff) {
        this.scrollRatio = ((double)this.getHeight() + entryHeight) / (heightDiff / 2.0);
    }

    public static interface OnPress {
        public void onPress(ScrollBarWidget var1);
    }
}

